/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.service.io;

import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.client.PIIOConcMaintDataBean;
import com.ibm.hsc.client.PIIODrawerConfigIdDataBean;
import com.ibm.hsc.client.PIIOOS400RetCodes;
import com.ibm.hsc.client.PIIORpaRetCodes;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementMaintenanceException;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.GenericGuiPanelBean;
import com.ibm.hwmca.fw.service.panel.RVUtility;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.managedsystem.DefaultServiceableElementMaintenance;
import com.ibm.hwmca.xfw.service.panel.PBCommonDisplayResults;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

public class PIIoConcurrentMaintenance
extends DefaultServiceableElementMaintenance {
    private static final String TRACE_MASKT = "XRVIOCMT";
    private static final String TRACE_MASKF = "XRVIOCMF";
    private static final String TRACE_MASKD = "XRVIOCMD";
    private static final int PHYP_RC_SUCCESS = 0;
    private static final int PHYP_RC_QUAL_SUCCESS = 256;
    private static final int PHYP_RC_INFORMATIONAL = 512;
    private static final int PHYP_RC_FAILURE = 768;
    private static final int PHYP_RC_BUSY = 769;
    private static final int PHYP_RC_INVALID_LOC = 770;
    private static final int PHYP_RC_NOT_SUPP = 771;
    private static final int PHYP_RC_LOCK_REQD = 772;
    private static final int PHYP_RC_WRG_PWR_STATE = 773;
    private static final int PHYP_RC_WRG_PWR_CNTRL = 774;
    private static final int PHYP_RC_PIPE_TARG_DEAD = 775;
    private static final int PHYP_RC_INVLD_PART_ID = 776;
    private static final int PHYP_RC_INVLD_RQST_ID = 777;
    private static final int PHYP_RC_DRC_ENT_IN_USE = 778;
    private static final int PHYP_RC_DMN_LOCKED = 779;
    private static final int PHYP_RC_NOT_AUTH = 780;
    private static final int PHYP_RC_DMA_BFR_SMALL = 781;
    private static final int PHYP_RC_INDIC_ROLL_ACTV = 782;
    private static final int PHYP_RC_BROKEN_LOOP = 783;
    private static final int PHYP_RC_REDUN_REQD = 784;
    private static final int PHYP_RC_INVLD_DRC_IDX = 785;
    private static final int PHYP_RC_INVLD_RIO_BUS_NUM = 786;
    private PIHSCCECCIMClient cimClient_ = null;
    public static final short SLOT = 3;
    public static final short PLANAR = 2;
    public static final short UNIT = 1;
    private static String BUNDLE_NAME = "com.ibm.hsc.ccfw.service.io.PIIoCMMessage";
    private static String SEPARATOR = RVUtility.getStrTableString((String)"separator", (String)BUNDLE_NAME, null);
    private static String MESSAGE_HEADER = RVUtility.getStrTableString((String)"message.msg", (String)BUNDLE_NAME, null);
    private static String RECOVERY_HEADER = RVUtility.getStrTableString((String)"recovery.msg", (String)BUNDLE_NAME, null);
    private static String ADDITIONAL_DATA_HEADER = RVUtility.getStrTableString((String)"additionaldata.msg", (String)BUNDLE_NAME, null);
    private static String NEW_LINE = "\n";
    private boolean doingDisplayServiceEffect = false;
    private boolean doingException = false;
    private static LinkedList serviceLockHolders = new LinkedList();

    public PIIoConcurrentMaintenance(String string, String string2, boolean bl, String string3) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance ctor, hostName[" + string + "],cecName[" + string2 + "],isMtmsName[" + bl + "],version[" + string3 + "]"));
        try {
            this.showBusy(new LocalizableText("Setting up connection to the Managed System: " + string2));
            this.cimClient_ = PIHSCCECCIMClient.createInstance(string, string2, bl, string3);
            this.destroyBusy();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("<-! PIIoConcurrentMaintenance ctor, exception caught: " + exception));
            Trace.trace((String)TRACE_MASKF, (Object)exception);
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        if (this.cimClient_ == null) {
            throw new ServiceableElementMaintenanceException("null cimClient handle returned from createInstance");
        }
        new StartConcMaintSession(new LocalizableText("Starting Concurrent Maintenance session with Managed System: " + string2)).processCommand();
        Trace.trace((String)TRACE_MASKT, (Object)("<- PIIoConcurrentMaintenance ctor, cimClient handle created: " + this.cimClient_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceEffect(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.getServiceEffect, powerDomainLocation: " + string));
        this.doingDisplayServiceEffect = true;
        try {
            new DisplayServiceEffect(string, new LocalizableText("Querying service effect for location: " + string)).processCommand();
        }
        finally {
            this.doingDisplayServiceEffect = false;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.getServiceEffect");
        return "";
    }

    public void systemLevelDeactivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.systemLevelDeactivate, powerDomainLocation: " + string));
        new SystemLevelDeactivate(string, new LocalizableText("System level deactivation for location: " + string)).processCommand();
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.systemLevelDeactivate");
    }

    public void systemLevelActivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.systemLevelActivate, powerDomainLocation: " + string));
        new SystemLevelActivate(string, new LocalizableText("System level activation for location: " + string)).processCommand();
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.systemLevelActivate");
    }

    public void elementLevelDeactivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.elementLevelDeactivate, powerDomainLocation: " + string));
        new FruLevelDeactivate(string, new LocalizableText("FRU level deactivation for location: " + string)).processCommand();
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.elementLevelDeactivate");
    }

    public void elementLevelActivate(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.elementLevelActivate, powerDomainLocation: " + string));
        new FruLevelActivate(string, new LocalizableText("FRU level activation for location: " + string)).processCommand();
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.elementLevelActivate");
    }

    public void identify(String string, int n) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.identify");
        try {
            int n2;
            if (n == 1) {
                this.showBusy(new LocalizableText("Turning on LED at location: " + string));
            } else {
                this.showBusy(new LocalizableText("Turning off LED at location: " + string));
            }
            int n3 = 0;
            int n4 = string.length();
            int[] nArray = new int[n4 - 17];
            int n5 = 0;
            for (n2 = 17; n2 < n4; ++n2) {
                if (string.charAt(n2) != '-') continue;
                ++n3;
                nArray[n5] = n2;
                ++n5;
            }
            n2 = 0;
            n5 = 0;
            int n6 = n4;
            for (int i = n3; i >= 0; --i) {
                if (i == 0) {
                    n2 = 1;
                }
                if (n2 == 0 && string.charAt(nArray[i - 1] + 1) == 'L') {
                    n5 = 1;
                    Trace.trace((String)TRACE_MASKD, (Object)("Skipping call for loc " + string.substring(0, n6)));
                }
                if (n5 == 0) {
                    Trace.trace((String)TRACE_MASKD, (Object)("Making call for loc " + string.substring(0, n6)));
                    n2 = this.doIdentify(string.substring(0, n6), n, n2 != 0);
                }
                n5 = 0;
                if (n2 != 0) {
                    break;
                }
                n6 = nArray[i - 1];
            }
        }
        catch (PIHscClientException pIHscClientException) {
            Trace.trace((String)TRACE_MASKF, (Object)("! PIIoConcurrentMaintenance.identify, exception caught: " + pIHscClientException));
            Trace.trace((String)TRACE_MASKF, (Object)pIHscClientException);
            throw new ServiceableElementMaintenanceException((Throwable)pIHscClientException);
        }
        finally {
            this.destroyBusy();
            Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.identify");
        }
    }

    private boolean doIdentify(String string, int n, boolean bl) throws PIHscClientException {
        try {
            this.cimClient_.setIdentifyLEDStates(new String[]{string}, new Integer[]{new Integer(n)}, new Integer[]{new Integer(2)});
            return true;
        }
        catch (PIHscClientException pIHscClientException) {
            Trace.trace((String)TRACE_MASKD, (Object)("cimClient.setIdentifyLEDStates, exception caught: " + pIHscClientException));
            if (bl) {
                throw pIHscClientException;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setServiceLock(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.setServiceLock, powerDomainLocation: " + string));
        boolean bl = false;
        try {
            while (!bl) {
                this.showBusy(new LocalizableText("Setting service lock for location: " + string));
                Hashtable hashtable = this.cimClient_.setServiceLock(string);
                Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.setServiceLock, KDK dumping returned hashtable: " + hashtable));
                this.destroyBusy();
                if (PIIoConcurrentMaintenance.containsBadRc(hashtable)) {
                    bl = !this.doRetry(PIIoConcurrentMaintenance.makeConcMaintDataBean(hashtable));
                    continue;
                }
                bl = true;
                String string2 = (String)this.userData.get("rvType");
                if (string2 == null || string2.equals("SET_SERVICE_LOCK")) continue;
                LinkedList linkedList = serviceLockHolders;
                synchronized (linkedList) {
                    String string3 = ((Object)((Object)this)).toString() + "|" + string;
                    if (!serviceLockHolders.contains(string3)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.setServiceLock, adding to lock list [" + string3 + "]"));
                        serviceLockHolders.add(string3);
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.setServiceLock, bypassing add to lock list [" + string3 + "] - already there???"));
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIIoConcurrentMaintenance.setServiceLock, exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (exception instanceof ServiceableElementMaintenanceException) {
                throw (ServiceableElementMaintenanceException)exception;
            }
            throw new ServiceableElementMaintenanceException((Throwable)exception);
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.setServiceLock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void resetServiceLock(String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.resetServiceLock, powerDomainLocation: " + string));
        boolean bl = false;
        Object object = serviceLockHolders;
        // MONITORENTER : object
        Object object2 = serviceLockHolders.toArray();
        String string2 = ((Object)((Object)this)).toString() + "|" + string;
        boolean bl2 = false;
        for (int i = 0; !bl2 && i < ((Object[])object2).length; ++i) {
            String string3 = (String)object2[i];
            Trace.trace((String)TRACE_MASKD, (Object)("PIIoConcurrentMaintenance.resetServiceLock lockKey[" + string3 + "], testLockLey[" + string2 + "]"));
            if (!string3.equals(string2)) continue;
            Trace.trace((String)TRACE_MASKD, (Object)"PIIoConcurrentMaintenance.resetServiceLock MATCH!");
            bl2 = true;
        }
        if (!bl2) {
            Trace.trace((String)TRACE_MASKF, (Object)"PIIoConcurrentMaintenance.resetServiceLock, bypassing resetServiceLock because the power domain lock is not held by this instance");
            bl = true;
        }
        // MONITOREXIT : object
        if (bl && (object = (String)this.userData.get("rvType")) != null && ((String)object).equals("RESET_SERVICE_LOCK")) {
            bl = false;
            Trace.trace((String)TRACE_MASKD, (Object)"PIIoConcurrentMaintenance.resetServiceLock, allowing the lock to flow for service action RESET_SERVICE_LOCK");
        }
        try {
            while (!bl) {
                Trace.trace((String)TRACE_MASKD, (Object)("PIIoConcurrentMaintenance.resetServiceLock issuing resetServiceLock for powerDomain[" + string + "]"));
                this.showBusy(new LocalizableText("Resetting service lock for location: " + string));
                object = this.cimClient_.resetServiceLock(string);
                this.destroyBusy();
                if (PIIoConcurrentMaintenance.containsBadRc((Hashtable)object)) {
                    bl = !this.doRetry(PIIoConcurrentMaintenance.makeConcMaintDataBean((Hashtable)object));
                    continue;
                }
                bl = true;
                object2 = serviceLockHolders;
                // MONITORENTER : object2
                string2 = ((Object)((Object)this)).toString() + "|" + string;
                serviceLockHolders.remove(string2);
                // MONITOREXIT : object2
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)("<-! PIIoConcurrentMaintenance.resetServiceLock, exception caught: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
            if (!(exception instanceof ServiceableElementMaintenanceException)) throw new ServiceableElementMaintenanceException((Throwable)exception);
            throw (ServiceableElementMaintenanceException)exception;
        }
        finally {
            this.destroyBusy();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.resetServiceLock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIIODrawerConfigIdDataBean[] getIoDrawerConfigIdAndMtms(String[] stringArray) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.getIoDrawerConfigIdAndMtms");
        PIIODrawerConfigIdDataBean[] pIIODrawerConfigIdDataBeanArray = null;
        boolean bl = false;
        while (!bl) {
            try {
                this.showBusy(new LocalizableText("Querying unit configuration information"));
                pIIODrawerConfigIdDataBeanArray = this.cimClient_.getIoDrawerConfigIdAndMtms(stringArray);
                bl = true;
                this.destroyBusy();
            }
            catch (Exception exception) {
                bl = true;
                this.destroyBusy();
                Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.getIoDrawerConfigIdAndMtms, exception caught: " + exception));
                Trace.trace((String)TRACE_MASKT, (Object)exception);
                if (!this.doRetry(exception)) {
                    Trace.trace((String)TRACE_MASKT, (Object)"<-! PIIoConcurrentMaintenance.getIoDrawerConfigIdAndMtms, user didn't want to retry");
                    throw new ServiceableElementMaintenanceException((Throwable)exception);
                }
                Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.getIoDrawerConfigIdAndMtms, exception caught, but user wants to retry");
                bl = false;
            }
            finally {
                this.destroyBusy();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.getIoDrawerConfigIdAndMtms");
        return pIIODrawerConfigIdDataBeanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIoDrawerConfigId(int n, String string) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.setIoDrawerConfigId configId[" + n + "],locationcode=[" + string + "]"));
        boolean bl = false;
        while (!bl) {
            try {
                this.showBusy(new LocalizableText("Setting unit configuration identifier (ID=" + n + ")"));
                this.cimClient_.setIoDrawerConfifId(n, string);
                bl = true;
                this.destroyBusy();
            }
            catch (Exception exception) {
                bl = true;
                this.destroyBusy();
                Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.setIoDrawerConfigId, exception caught: " + exception));
                Trace.trace((String)TRACE_MASKT, (Object)exception);
                if (!this.doRetry(exception)) {
                    Trace.trace((String)TRACE_MASKT, (Object)"<-! PIIoConcurrentMaintenance.setIoDrawerConfigId, user didn't want to retry");
                    throw new ServiceableElementMaintenanceException((Throwable)exception);
                }
                Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.setIoDrawerConfigId, exception caught, but user wants to retry");
                bl = false;
            }
            finally {
                this.destroyBusy();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.setIoDrawerConfigId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIoDrawerMtms(String string, String string2, String string3, String string4) throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> PIIoConcurrentMaintenance.setIoDrawerMtms type[" + string + "],model[" + string2 + "],serialNum[" + string3 + "],locationcode[" + string4 + "]"));
        boolean bl = false;
        while (!bl) {
            try {
                this.showBusy(new LocalizableText("Setting unit type/model/serial configuration information"));
                this.cimClient_.setIoDrawerMtms(string, string2, string3, string4);
                bl = true;
                this.destroyBusy();
            }
            catch (Exception exception) {
                bl = true;
                this.destroyBusy();
                Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.setIoDrawerMtms, exception caught: " + exception));
                Trace.trace((String)TRACE_MASKT, (Object)exception);
                if (!this.doRetry(exception)) {
                    Trace.trace((String)TRACE_MASKT, (Object)"<-! PIIoConcurrentMaintenance.setIoDrawerMtms, user didn't want to retry");
                    throw new ServiceableElementMaintenanceException((Throwable)exception);
                }
                Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.setIoDrawerMtms, exception caught, but user wants to retry");
                bl = false;
            }
            finally {
                this.destroyBusy();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.setIoDrawerMtms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInactive() throws ServiceableElementMaintenanceException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.clearInactive");
        boolean bl = false;
        while (!bl) {
            try {
                this.showBusy(new LocalizableText("Clearing inactive I/O enclosure information"));
                this.cimClient_.clearInactive();
                bl = true;
                this.destroyBusy();
            }
            catch (Exception exception) {
                bl = true;
                this.destroyBusy();
                Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.clearInactive, exception caught: " + exception));
                Trace.trace((String)TRACE_MASKT, (Object)exception);
                if (!this.doRetry(exception)) {
                    Trace.trace((String)TRACE_MASKT, (Object)"<-! PIIoConcurrentMaintenance.clearInactive, user didn't want to retry");
                    throw new ServiceableElementMaintenanceException((Throwable)exception);
                }
                Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.clearInactive, exception caught, but user wants to retry");
                bl = false;
            }
            finally {
                this.destroyBusy();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.clearInactive");
    }

    public static boolean containsBadRc(PIIOConcMaintDataBean pIIOConcMaintDataBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.containsBadRc(dataBean)");
        PIIOOS400RetCodes[] pIIOOS400RetCodesArray = pIIOConcMaintDataBean.getOS400RetCodeList();
        PIIORpaRetCodes[] pIIORpaRetCodesArray = pIIOConcMaintDataBean.getRpaRetCodeList();
        if (pIIORpaRetCodesArray != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.containsBadRc rpaRetCodes.length=" + pIIORpaRetCodesArray.length));
            for (int i = 0; i < pIIORpaRetCodesArray.length; ++i) {
                if (pIIORpaRetCodesArray[i].getRetCodeErrorType() == 0) continue;
                Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.containsBadRc(dataBean) returns true");
                return true;
            }
        }
        if (pIIOOS400RetCodesArray != null) {
            for (int i = 0; i < pIIOOS400RetCodesArray.length; ++i) {
                Vector vector = pIIOOS400RetCodesArray[i].getReturnCodesVec();
                for (int j = 0; j < vector.size(); ++j) {
                    Integer n = (Integer)vector.get(j);
                    if (n == 0) continue;
                    Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.containsBadRc(dataBean) returns true");
                    return true;
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.containsBadRc(dataBean) returns false");
        return false;
    }

    public static boolean containsBadRc(Hashtable hashtable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.containsBadRc(hashTable)");
        Vector vector = (Vector)hashtable.get("ReturnCode");
        if (vector != null) {
            Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.containsBadRc(hashTable) vRetCodes.size() == " + vector.size()));
            for (int i = 0; i < vector.size(); ++i) {
                Integer n = (Integer)vector.get(i);
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.containsBadRc(hashTable) vRetCodes(" + i + ")=" + n));
                if (n == 0) continue;
                Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.containsBadRc(hashTable) returns true");
                return true;
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"PIIoConcurrentMaintenance.containsBadRc(hashTable) returned hashtable does not contain RETURN_CODE key!!!");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.containsBadRc(hashTable) returns false");
        return false;
    }

    protected boolean doRetry(Object object) {
        boolean bl = false;
        try {
            CommonDataBean commonDataBean = null;
            commonDataBean = object instanceof Exception ? this.panelSetup((Exception)object) : this.panelSetup((PIIOConcMaintDataBean)object);
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            commonDataBean = (CommonDataBean)genericGui.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", commonDataBean.getTemplateName(), (GenericGuiPanelBean)commonDataBean, this.userData);
            if (commonDataBean instanceof PBCommonDisplayResults && ((PBCommonDisplayResults)commonDataBean).isRetryButtonSelected()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.doRetry caught exception: " + exception));
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        return bl;
    }

    protected CommonDataBean panelSetup(Exception exception) {
        String string = exception.getMessage();
        string = string == null || string.trim().length() == 0 ? exception.getClass().getName() : "Exception text: " + string;
        String string2 = "An exception has been encountered:\n" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("failure_count", "1");
        hashMap.put("informational_count", "0");
        hashMap.put("qualified_success_count", "0");
        String string3 = RVUtility.getStrTableString((String)"summary.msg", (String)BUNDLE_NAME, hashMap);
        String string4 = (String)this.serviceableElement.getProperty((Object)"DESC");
        String string5 = (String)this.serviceableElement.getProperty((Object)"LOCATION");
        PBCommonDisplayResults pBCommonDisplayResults = new PBCommonDisplayResults(string3, string2, string4 == null ? "" : string4, string5 == null ? "" : string5);
        this.setCommonSubs((CommonDataBean)pBCommonDisplayResults);
        pBCommonDisplayResults.hideCancelButton();
        pBCommonDisplayResults.disableControl("RadioButton1");
        pBCommonDisplayResults.setButtongroupSelection(new String[]{"RadioButton2"});
        return pBCommonDisplayResults;
    }

    protected CommonDataBean panelSetup(PIIOConcMaintDataBean pIIOConcMaintDataBean) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        int n3;
        PIIORpaRetCodes[] pIIORpaRetCodesArray = pIIOConcMaintDataBean.getRpaRetCodeList();
        PIIOOS400RetCodes[] pIIOOS400RetCodesArray = pIIOConcMaintDataBean.getOS400RetCodeList();
        String string6 = "";
        boolean bl = true;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (pIIORpaRetCodesArray != null) {
            Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: aRpaRC.length=" + pIIORpaRetCodesArray.length));
        }
        if (pIIOOS400RetCodesArray != null) {
            Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: a400RC.length=" + pIIOOS400RetCodesArray.length));
        }
        if (pIIORpaRetCodesArray != null) {
            for (n3 = 0; n3 < pIIORpaRetCodesArray.length; ++n3) {
                hashMap.clear();
                object3 = pIIORpaRetCodesArray[n3].getRmcRetCode();
                object2 = pIIORpaRetCodesArray[n3].getRpaRetCode();
                object = pIIORpaRetCodesArray[n3].getRetCodeErrorType();
                String string7 = pIIORpaRetCodesArray[n3].getUserException();
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: aRpaRC[" + n3 + "].getRmcRetCode()=" + object3));
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: aRpaRC[" + n3 + "].getRpaRetCode()=" + object2));
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: aRpaRC[" + n3 + "].getRetCodeErrorType()=" + object));
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup: aRpaRC[" + n3 + "].getUserException()=" + string7));
                n2 = object3 == null ? 0 : (Integer)object3;
                int n7 = object2 == null ? 0 : (Integer)object2;
                n = object == null ? 0 : (Integer)object;
                bl2 = true;
                if (!bl) {
                    string6 = string6 + SEPARATOR + NEW_LINE;
                } else {
                    bl = false;
                }
                if (n2 != 0 || n7 != 0) {
                    if (n7 != 0) {
                        ++n4;
                        hashMap.put("partitiontype", "RPA");
                        string5 = RVUtility.getStrTableString((String)"partition.type.msg", (String)BUNDLE_NAME, hashMap);
                        hashMap.put("returncodetype", RVUtility.getStrTableString((String)"rc.0300", (String)BUNDLE_NAME, null));
                        string4 = RVUtility.getStrTableString((String)"returncode.type.msg", (String)BUNDLE_NAME, hashMap);
                        string3 = MESSAGE_HEADER + NEW_LINE + string7;
                        string6 = string6 + string5 + NEW_LINE + string4 + NEW_LINE + string3 + NEW_LINE;
                    }
                    if (n2 == 0) continue;
                    ++n4;
                    hashMap.put("partitiontype", "RMC");
                    string5 = RVUtility.getStrTableString((String)"partition.type.msg", (String)BUNDLE_NAME, hashMap);
                    hashMap.put("returncodetype", RVUtility.getStrTableString((String)"rc.0300", (String)BUNDLE_NAME, null));
                    string4 = RVUtility.getStrTableString((String)"returncode.type.msg", (String)BUNDLE_NAME, hashMap);
                    string3 = PIIoConcurrentMaintenance.toHexStr_4(n2);
                    hashMap.put("returncode", "0x" + string3);
                    string2 = RVUtility.getStrTableString((String)"returncode.msg", (String)BUNDLE_NAME, hashMap);
                    string = MESSAGE_HEADER + NEW_LINE + string7;
                    string6 = string6 + string5 + NEW_LINE + string2 + NEW_LINE + string4 + NEW_LINE + string + NEW_LINE;
                    continue;
                }
                ++n4;
                hashMap.put("returncodetype", RVUtility.getStrTableString((String)"rc.0300", (String)BUNDLE_NAME, null));
                string5 = RVUtility.getStrTableString((String)"returncode.type.msg", (String)BUNDLE_NAME, hashMap);
                string4 = MESSAGE_HEADER + NEW_LINE + string7;
                string6 = string6 + string5 + NEW_LINE + string4 + NEW_LINE;
            }
        }
        if (pIIOOS400RetCodesArray != null) {
            for (n3 = 0; n3 < pIIOOS400RetCodesArray.length; ++n3) {
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup processing PIIOOS400RetCodes[" + n3 + "]"));
                hashMap.clear();
                object3 = pIIOOS400RetCodesArray[n3].getReturnCodesVec();
                object2 = pIIOOS400RetCodesArray[n3].getResponseDataVec();
                hashMap.put("partitionid", String.valueOf(pIIOOS400RetCodesArray[n3].getPartitionID()));
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "].getReturnCodesVec()==" + pIIOOS400RetCodesArray[n3].getReturnCodesVec()));
                if (pIIOOS400RetCodesArray[n3].getReturnCodesVec() != null) {
                    Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "].getReturnCodesVec().size()==" + pIIOOS400RetCodesArray[n3].getReturnCodesVec().size()));
                }
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "].getResponseDataVec()==" + pIIOOS400RetCodesArray[n3].getResponseDataVec()));
                if (pIIOOS400RetCodesArray[n3].getReturnCodesVec() != null) {
                    Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "].getResponseDataVec().size()==" + pIIOOS400RetCodesArray[n3].getResponseDataVec().size()));
                }
                Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "].getPartitionId()==" + pIIOOS400RetCodesArray[n3].getPartitionID()));
                if (pIIOOS400RetCodesArray[n3].getPartitionID() == 0) {
                    object = "phyp.rc.";
                    hashMap.put("partitiontype", "PHYP");
                } else {
                    object = "os400.rc.";
                    hashMap.put("partitiontype", "i5/OS");
                }
                for (int i = 0; i < ((Vector)object3).size(); ++i) {
                    String string8;
                    Object object4;
                    n2 = (Integer)((Vector)object3).get(i);
                    Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.panelSetup  PIIOOS400RetCodes[" + n3 + "], rc[" + i + "] ==" + PIIoConcurrentMaintenance.toHexStr_4(n2)));
                    if (n2 >= 65280) {
                        object = "cim.rc.";
                    }
                    if (n2 == 0) continue;
                    if (!bl) {
                        string6 = string6 + SEPARATOR + NEW_LINE;
                    } else {
                        bl = false;
                    }
                    String string9 = PIIoConcurrentMaintenance.toHexStr_4(n2);
                    hashMap.put("returncode", "0x" + string9);
                    n = n2 / 256 * 256;
                    hashMap.put("returncodetype", RVUtility.getStrTableString((String)("rc." + PIIoConcurrentMaintenance.toHexStr_4(n)), (String)BUNDLE_NAME, null));
                    if (n2 >= 768) {
                        ++n4;
                        bl2 = true;
                    } else if (n2 >= 512) {
                        ++n5;
                    } else {
                        ++n6;
                    }
                    string5 = RVUtility.getStrTableString((String)"partition.id.msg", (String)BUNDLE_NAME, hashMap);
                    string4 = RVUtility.getStrTableString((String)"partition.type.msg", (String)BUNDLE_NAME, hashMap);
                    string3 = RVUtility.getStrTableString((String)"returncode.msg", (String)BUNDLE_NAME, hashMap);
                    string2 = RVUtility.getStrTableString((String)"returncode.type.msg", (String)BUNDLE_NAME, hashMap);
                    string = MESSAGE_HEADER + NEW_LINE + RVUtility.getStrTableString((String)((String)object + string9 + ".msg"), (String)BUNDLE_NAME, hashMap);
                    string6 = string6 + string5 + NEW_LINE + string4 + NEW_LINE + string3 + NEW_LINE + string2 + NEW_LINE + string + NEW_LINE;
                    String string10 = (String)object + string9 + ".additionaldata.msg";
                    String string11 = RVUtility.getStrTableString((String)string10, (String)BUNDLE_NAME, hashMap);
                    if (!string11.equals(string10)) {
                        object4 = (byte[])((Vector)object2).get(i);
                        string11 = this.resolveAdditionalData(string11, (byte[])object4);
                        string6 = string6 + ADDITIONAL_DATA_HEADER + NEW_LINE + string11 + NEW_LINE;
                    }
                    if ((string8 = RVUtility.getStrTableString((String)(object4 = (Object)((String)object + string9 + ".recovery.msg")), (String)BUNDLE_NAME, hashMap)).equals(object4)) continue;
                    string6 = string6 + RECOVERY_HEADER + NEW_LINE + string8 + NEW_LINE;
                }
            }
        }
        hashMap.put("failure_count", String.valueOf(n4));
        hashMap.put("informational_count", String.valueOf(n5));
        hashMap.put("qualified_success_count", String.valueOf(n6));
        String string12 = RVUtility.getStrTableString((String)"summary.msg", (String)BUNDLE_NAME, hashMap);
        object3 = (String)this.serviceableElement.getProperty((Object)"DESC");
        object2 = (String)this.serviceableElement.getProperty((Object)"LOCATION");
        object = new PBCommonDisplayResults(string12, string6, (String)(object3 == null ? "" : object3), (String)(object2 == null ? "" : object2));
        this.setCommonSubs((CommonDataBean)object);
        if (!this.doingDisplayServiceEffect) {
            object.hideCancelButton();
        }
        if (bl2) {
            object.disableControl("RadioButton1");
            object.setButtongroupSelection(new String[]{"RadioButton2"});
        }
        return object;
    }

    public static PIIOConcMaintDataBean makeConcMaintDataBean(Hashtable hashtable) {
        if (hashtable.get("ReturnCode") instanceof Vector) {
            return PIIoConcurrentMaintenance.makeConcMaintDataBean_fromVectorForm(hashtable);
        }
        return PIIoConcurrentMaintenance.makeConcMaintDataBean_fromSingleForm(hashtable);
    }

    public static PIIOConcMaintDataBean makeConcMaintDataBean_fromSingleForm(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Vector vector = new Vector();
        vector.add(hashtable.get("ReturnCode"));
        hashtable2.put("ReturnCode", vector);
        Vector vector2 = new Vector();
        vector2.add(hashtable.get("ResponseData"));
        hashtable2.put("ResponseData", vector2);
        return PIIoConcurrentMaintenance.makeConcMaintDataBean_fromVectorForm(hashtable2);
    }

    public static PIIOConcMaintDataBean makeConcMaintDataBean_fromVectorForm(Hashtable hashtable) {
        Vector vector = (Vector)hashtable.get("ReturnCode");
        Vector vector2 = (Vector)hashtable.get("ResponseData");
        PIIOOS400RetCodes pIIOOS400RetCodes = new PIIOOS400RetCodes(0, vector, vector2);
        return new PIIOConcMaintDataBean(null, new PIIOOS400RetCodes[]{pIIOOS400RetCodes});
    }

    public static String toHexStr_4(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return string.toUpperCase();
    }

    protected String resolveAdditionalData(String string, byte[] byArray) {
        Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.resolveAdditionalData: source string: " + string));
        String string2 = "";
        String string3 = string;
        try {
            int n = string3.indexOf(37);
            if (n != -1) {
                do {
                    String string4;
                    String string5;
                    if ((string5 = string3.substring(++n)).startsWith("4.5.LENGTH.EBCDIC")) {
                        int n2 = byArray[4] * 16 + byArray[5];
                        byte[] byArray2 = new byte[n2];
                        for (int i = 0; i < n2; ++i) {
                            byArray2[i] = byArray[i + 6];
                        }
                        string4 = new String(byArray2, "Cp500");
                        string2 = string2 + string3.substring(0, n - 1) + string4;
                        string3 = string3.substring(n + "4.5.LENGTH.EBCDIC".length());
                        continue;
                    }
                    if (string5.startsWith("1.EBCDIC")) {
                        int n3 = 0;
                        int n4 = 1;
                        while (byArray[n4] != 0) {
                            ++n4;
                            ++n3;
                        }
                        byte[] byArray3 = new byte[n3];
                        int n5 = 1;
                        while (byArray[n5] != 0) {
                            byArray3[n5 - 1] = byArray[n5];
                            ++n5;
                        }
                        string4 = new String(byArray3, "Cp500");
                        string2 = string2 + string3.substring(0, n - 1) + string4;
                        string3 = string3.substring(n + "1.EBCDIC".length());
                        continue;
                    }
                    if (string5.startsWith("0.EBCDIC")) {
                        int n6 = 0;
                        n6 = 0;
                        while (byArray[n6] != 0) {
                            ++n6;
                        }
                        byte[] byArray4 = new byte[n6];
                        for (int i = 0; i < n6; ++i) {
                            byArray4[i] = byArray[i];
                        }
                        string4 = new String(byArray4, "Cp500");
                        string2 = string2 + string3.substring(0, n - 1) + string4;
                        string3 = string3.substring(n + "1.EBCDIC".length());
                        continue;
                    }
                    if (string5.startsWith("4.7.BYTE")) {
                        String string6 = "";
                        for (int i = 4; i < 8; ++i) {
                            string4 = Integer.toHexString(0xFF & byArray[i]);
                            if (string4.length() == 1) {
                                string4 = "0" + string4;
                            }
                            string6 = string6 + string4;
                        }
                        string2 = string2 + string3.substring(0, n - 1) + string6;
                        string3 = string3.substring(n + "4.7.BYTE".length());
                        continue;
                    }
                    if (string5.startsWith("0.7.BYTE")) {
                        String string7 = "";
                        for (int i = 0; i < 8; ++i) {
                            string4 = Integer.toHexString(0xFF & byArray[i]);
                            if (string4.length() == 1) {
                                string4 = "0" + string4;
                            }
                            string7 = string7 + string4;
                        }
                        string2 = string2 + string3.substring(0, n - 1) + string7;
                        string3 = string3.substring(n + "0.7.BYTE".length());
                        continue;
                    }
                    if (string5.startsWith("0.3.BYTE")) {
                        String string8 = "";
                        for (int i = 0; i < 4; ++i) {
                            string4 = Integer.toHexString(0xFF & byArray[i]);
                            if (string4.length() == 1) {
                                string4 = "0" + string4;
                            }
                            string8 = string8 + string4;
                        }
                        string2 = string2 + string3.substring(0, n - 1) + string8;
                        string3 = string3.substring(n + "0.3.BYTE".length());
                        continue;
                    }
                    if (string5.startsWith("4.5.LENGTH.ASCII")) {
                        int n7 = byArray[4] * 16 + byArray[5];
                        byte[] byArray5 = new byte[n7];
                        for (int i = 0; i < n7; ++i) {
                            byArray5[i] = byArray[i + 6];
                        }
                        string4 = new String(byArray5);
                        string2 = string2 + string3.substring(0, n - 1) + string4;
                        string3 = string3.substring(n + "4.5.LENGTH.ASCII".length());
                        continue;
                    }
                    Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.resolveAdditionalData: unmapped substitiion - assuming '%' is intended in msg: " + string3));
                    string2 = string2 + "%";
                    string3 = string3.substring(n);
                } while ((n = string3.indexOf(37)) != -1);
                string2 = string2 + string3;
            } else {
                string2 = string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.resolveAdditionalData: EBCDIC Cp500 not supported??? Returning source string");
            Trace.trace((String)TRACE_MASKT, (Object)unsupportedEncodingException);
            string2 = string;
        }
        Trace.trace((String)TRACE_MASKT, (Object)("PIIoConcurrentMaintenance.resolveAdditionalData: output string: " + string2));
        return string2;
    }

    public static short getIOType(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(45, n2 + 1)) != -1) {
            ++n;
        }
        short s = n == 0 ? (short)1 : (n == 1 ? (short)2 : 3);
        Trace.trace((String)TRACE_MASKT, (Object)("<> PIIoConcurrentMaintenance.getIOType for powerDomainLocation[" + string + "]==" + s));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        LinkedList linkedList = serviceLockHolders;
        synchronized (linkedList) {
            Object[] objectArray = serviceLockHolders.toArray();
            String string = ((Object)((Object)this)).toString() + "|";
            Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.finalize for instance[" + ((Object)((Object)this)).toString() + "]"));
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                Trace.trace((String)TRACE_MASKD, (Object)("PIIoConcurrentMaintenance.finalize testing lock key[" + string2 + "]"));
                if (!string2.startsWith(string)) continue;
                Trace.trace((String)TRACE_MASKD, (Object)"PIIoConcurrentMaintenance.finalize MATCH!!!");
                String string3 = string2.substring(string.length());
                try {
                    Trace.trace((String)TRACE_MASKF, (Object)("PIIoConcurrentMaintenance.finalize freeing lock for power domain[" + string3 + "] (lock key=[" + string2 + "])"));
                    this.cimClient_.resetServiceLock(string3);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"PIIoConcurrentMaintenance.finalize exception caught freeing lock - ignoring");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
                serviceLockHolders.remove(string2);
            }
        }
    }

    protected void showBusy(LocalizableText localizableText) {
        try {
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            genericGui.showBusyDialog(new LocalizableText("Hardware operation in progress..."), localizableText, this.userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void destroyBusy() {
        try {
            GenericGui genericGui = (GenericGui)this.userData.get("DISPLAY_HANDLE");
            genericGui.destroyBusyDialog(this.userData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCommonSubs(CommonDataBean commonDataBean) {
        HashMap hashMap = new HashMap();
        hashMap.put("machinetype", this.serviceableElement.getProperties().get("ENCLOSURE_TYPE"));
        hashMap.put("model", this.serviceableElement.getProperties().get("ENCLOSURE_MODEL"));
        hashMap.put("serialnumber", this.serviceableElement.getProperties().get("ENCLOSURE_SERIAL"));
        hashMap.put("location", this.serviceableElement.getProperties().get("LOCATION"));
        hashMap.put("description", this.serviceableElement.getProperties().get("DESC"));
        hashMap.put("partnum", this.serviceableElement.getProperties().get("PART_NUM"));
        commonDataBean.setDataMap(hashMap);
    }

    protected class StartConcMaintSession
    extends CMCommandDriver {
        public StartConcMaintSession(LocalizableText localizableText) {
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            PIIOOS400RetCodes[] pIIOOS400RetCodesArray = PIIoConcurrentMaintenance.this.cimClient_.startConcMaintSession();
            return new PIIOConcMaintDataBean(null, pIIOOS400RetCodesArray);
        }
    }

    protected class DisplayServiceEffect
    extends CMCommandDriver {
        private String powerDomainLocation;

        public DisplayServiceEffect(String string, LocalizableText localizableText) {
            this.powerDomainLocation = string;
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            return PIIoConcurrentMaintenance.this.cimClient_.displayServiceEffect(this.powerDomainLocation, PIIoConcurrentMaintenance.getIOType(this.powerDomainLocation));
        }
    }

    protected class FruLevelActivate
    extends CMCommandDriver {
        private String powerDomainLocation;

        public FruLevelActivate(String string, LocalizableText localizableText) {
            this.powerDomainLocation = string;
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            return PIIoConcurrentMaintenance.makeConcMaintDataBean(PIIoConcurrentMaintenance.this.cimClient_.fruLevelActivate(this.powerDomainLocation));
        }
    }

    protected class FruLevelDeactivate
    extends CMCommandDriver {
        private String powerDomainLocation;

        public FruLevelDeactivate(String string, LocalizableText localizableText) {
            this.powerDomainLocation = string;
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            return PIIoConcurrentMaintenance.makeConcMaintDataBean(PIIoConcurrentMaintenance.this.cimClient_.fruLevelDeactivate(this.powerDomainLocation));
        }
    }

    protected class SystemLevelActivate
    extends CMCommandDriver {
        private String powerDomainLocation;

        public SystemLevelActivate(String string, LocalizableText localizableText) {
            this.powerDomainLocation = string;
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            return PIIoConcurrentMaintenance.this.cimClient_.systemLevelActivate(this.powerDomainLocation, PIIoConcurrentMaintenance.getIOType(this.powerDomainLocation));
        }
    }

    protected class SystemLevelDeactivate
    extends CMCommandDriver {
        private String powerDomainLocation;

        public SystemLevelDeactivate(String string, LocalizableText localizableText) {
            this.powerDomainLocation = string;
            this.busyMessage = localizableText;
        }

        public PIIOConcMaintDataBean fireCommand() throws Exception {
            return PIIoConcurrentMaintenance.this.cimClient_.systemLevelDeactivate(this.powerDomainLocation, PIIoConcurrentMaintenance.getIOType(this.powerDomainLocation));
        }
    }

    protected abstract class CMCommandDriver {
        protected LocalizableText busyMessage;

        protected CMCommandDriver() {
        }

        public abstract PIIOConcMaintDataBean fireCommand() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processCommand() throws ServiceableElementMaintenanceException {
            Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)"-> PIIoConcurrentMaintenance.CMCommandDriver.processCommand");
            boolean bl = false;
            try {
                while (!bl) {
                    try {
                        PIIoConcurrentMaintenance.this.showBusy(this.busyMessage);
                        PIIOConcMaintDataBean pIIOConcMaintDataBean = this.fireCommand();
                        PIIoConcurrentMaintenance.this.destroyBusy();
                        if (PIIoConcurrentMaintenance.containsBadRc(pIIOConcMaintDataBean)) {
                            bl = !PIIoConcurrentMaintenance.this.doRetry(pIIOConcMaintDataBean);
                            continue;
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        PIIoConcurrentMaintenance.this.destroyBusy();
                        Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)("!!! PIIoConcurrentMaintenance.CMCommandDriver.processCommand, exception caught: " + exception));
                        Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)exception);
                        bl = !PIIoConcurrentMaintenance.this.doRetry(exception);
                    }
                    finally {
                        PIIoConcurrentMaintenance.this.destroyBusy();
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)("<-! PIIoConcurrentMaintenance.CMCommandDriver.processCommand, exception caught: " + exception));
                Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)exception);
                if (exception instanceof ServiceableElementMaintenanceException) {
                    throw (ServiceableElementMaintenanceException)exception;
                }
                throw new ServiceableElementMaintenanceException((Throwable)exception);
            }
            Trace.trace((String)PIIoConcurrentMaintenance.TRACE_MASKT, (Object)"<- PIIoConcurrentMaintenance.CMCommandDriver.processCommand");
        }
    }
}

